#include "FuncSymbolTable.hpp"

/* destruktor */
FuncSymbolTable::~FuncSymbolTable() {

    /* unistavamo promenljive koje se cuvaju u mapi */
    for (auto it = _vars.begin(); it != _vars.end(); it++) {
        delete it->second;
    }
}

/* konstrutkor kopije */
FuncSymbolTable::FuncSymbolTable(const FuncSymbolTable& fs) {

    /* redom kopiramo elemente arugmenta */
    for (auto it = fs._vars.begin(); it != fs._vars.end(); it++) {
        /* u novu mapu dodajemo kopije postojecih objekata, tj. 
         * radimo duboko kopiranje
         */
        _vars[it->first] = it->second->Clone();
    }
}

/* operator dodele */
FuncSymbolTable& FuncSymbolTable::operator =(const FuncSymbolTable& fs) {

    /* self-assignment provera */
    if (this == &fs)
        return *this;

    /* unistavamo promenljive koje se cuvaju u mapi */
    for (auto it = _vars.begin(); it != _vars.end(); it++) {
        delete it->second;
    }

    /* brisemo sve elemente iz mape*/
    _vars.clear();

    /* redom kopiramo elemente arugmenta */
    for (auto it = fs._vars.begin(); it != fs._vars.end(); it++) {
        /* u novu mapu dodajemo kopije postojecih objekata, tj. 
         * radimo duboko kopiranje
         */
        _vars[it->first] = it->second->Clone();
    }

    /* vracamo izmenjeni objekat */
    return *this;
}

/* metod proverava da li je kljuc s u mapi */
bool FuncSymbolTable::VariableDefined(const std::string& s) const {

    /* dovoljno je da rezultat pretrage uporedimo sa end iteratorom */
    return _vars.find(s) != _vars.end();
}
/* metod vraca vrednost funkcije sa imenom s u tacki x */
double FuncSymbolTable::VariableValue(const std::string& s, double x) const {

    /* ako promenljiva s nije definisana, bacamo izuzetak */
    if (!VariableDefined(s))    
        throw std::invalid_argument("Variable not defined");

    /* ako jeste, vracamo vrednos funkcije u tacki x */
    return _vars.find(s)->second->Value(x);
}

/* metod vraca promenljivu sa imenom s iz mape */
Funkcija* FuncSymbolTable::GetVariable(const std::string& s) const{

    /* ako promenljiva ne postoji, vracamo nullptr kao signal greske */
    if (!VariableDefined(s))    
        return nullptr;

    /* inace, vracamo kopiju promenljive iz mape */
    return _vars.find(s)->second->Clone();
}

/* metod definise ili menja vrednost promenljvie s u mapi */
void FuncSymbolTable::DefineVariable(const std::string& s, Funkcija* f){

    /* bitno, u mapi direktno cuvamo pokazivace, pa treba biti obazriv sa oslobadjanjem memorije */
    _vars[s] = f;
}